/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCButton;
import jclass.bwt.JCCheckboxGroup;
import jclass.bwt.JCContainer;
import jclass.bwt.JCGridLayout;
import jclass.bwt.JCLabel;
import jclass.bwt.JCTextComponent;
import jclass.chart.JCChart;
import jclass.chart.JCCustomizerPage;
import jclass.chart.customizer.JCBooleanEditor;
import jclass.chart.customizer.JCFileNameEditor;
import jclass.chart.customizer.JCPropertyPage;
import jclass.chart.customizer.TestChart;

public class JCLoadDialog
extends JCPropertyPage
implements JCActionListener {
    JCCheckboxGroup modeBox;
    JCBooleanEditor paramCheck;
    JCBooleanEditor serialCheck;
    JCFileNameEditor fileSelector;
    JCLabel loadedLabel;
    JCButton addButton;
    JCButton previewButton;
    JCButton removeButton;
    JCButton cancelButton;
    Object preview;
    Object target;
    Object model;

    public void init() {
        super.init();
        this.setLayout(new BorderLayout());
        JCContainer jCContainer = new JCContainer();
        jCContainer.setLayout(new BorderLayout());
        JCContainer jCContainer2 = new JCContainer();
        jCContainer2.setLayout(new JCGridLayout(2, 1));
        String string = "Load from ";
        this.modeBox = new JCCheckboxGroup(string);
        this.modeBox.setInsets(new Insets(3, 3, 1, 1));
        this.modeBox.setLayout(new GridLayout(1, 2));
        this.paramCheck = new JCBooleanEditor("Param File");
        this.paramCheck.addPropertyChangeListener(this);
        this.modeBox.add(this.paramCheck);
        this.serialCheck = new JCBooleanEditor("Serialized File");
        this.serialCheck.addPropertyChangeListener(this);
        this.modeBox.add(this.serialCheck);
        jCContainer2.add(this.modeBox);
        JCContainer jCContainer3 = new JCContainer();
        jCContainer3.setLayout(new JCAlignerLayout(2, 1, 3));
        jCContainer3.add(new JCLabel("File:"));
        this.fileSelector = new JCFileNameEditor();
        this.fileSelector.init();
        this.fileSelector.saveButton.disable();
        ((JCTextComponent)this.fileSelector.nameField).setText("test.html");
        this.fileSelector.addPropertyChangeListener(this);
        jCContainer3.add(this.fileSelector);
        jCContainer3.add(new JCLabel("Loaded:"));
        this.loadedLabel = new JCLabel("Nothing yet");
        this.loadedLabel.setFont(new Font("TimesRoman", 1, 14));
        this.loadedLabel.setAlignment(3);
        jCContainer3.add(this.loadedLabel);
        jCContainer2.add(jCContainer3);
        jCContainer.add("Center", jCContainer2);
        JCContainer jCContainer4 = new JCContainer();
        jCContainer4.setLayout(new FlowLayout(1, 10, 2));
        this.addButton = new JCButton("Replace");
        this.addButton.addActionListener(this);
        this.addButton.disable();
        jCContainer4.add(this.addButton);
        if (this.hasPreview()) {
            this.previewButton = new JCButton("Preview");
            this.previewButton.addActionListener(this);
            jCContainer4.add(this.previewButton);
        }
        this.removeButton = new JCButton("Remove");
        this.removeButton.addActionListener(this);
        jCContainer4.add(this.removeButton);
        this.cancelButton = new JCButton("Cancel");
        this.cancelButton.addActionListener(this);
        jCContainer4.add(this.cancelButton);
        jCContainer.add("South", jCContainer4);
        this.add("South", jCContainer);
        this.paramCheck.setState(1);
    }

    public Object getObject() {
        return this.target;
    }

    public void setObject(Object object) {
        System.out.println("JCLoadDialog setObject: " + object);
        this.target = object;
        if (this.target == null) {
            this.loadedLabel.setText("Nothing loaded");
        } else {
            this.loadedLabel.setText(this.target.toString());
        }
        if (this.hasPreview() && this.preview != null) {
            this.showPreview();
        }
    }

    public void setModel(Object object) {
        if (object == null) {
            return;
        }
        this.model = object;
    }

    public boolean hasPreview() {
        return true;
    }

    public void showPreview() {
        Object object = this.getObject();
        if (object == null) {
            if (this.preview != null) {
                this.remove((Component)this.preview);
                this.preview = object;
                JCPropertyPage.resizeFrame(this);
                return;
            }
        } else {
            if (object instanceof JCChart) {
                this.preview = object;
                JCChart jCChart = (JCChart)object;
                if (this.preview instanceof Component) {
                    this.remove((Component)this.preview);
                }
                this.add("Center", jCChart);
                JCPropertyPage.resizeFrame(this);
                return;
            }
            JCCustomizerPage.showError("Preview not available for:" + object);
        }
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() == this.cancelButton) {
            ((Component)JCPropertyPage.getFrame(this)).hide();
            return;
        }
        if (jCActionEvent.getSource() == this.addButton) {
            this.firePropertyChange(null, null, this.getObject());
            ((Component)JCPropertyPage.getFrame(this)).hide();
            return;
        }
        if (jCActionEvent.getSource() == this.previewButton) {
            this.showPreview();
            return;
        }
        if (jCActionEvent.getSource() == this.removeButton) {
            this.setObject(null);
        }
    }

    public void propertyChanged(Object object, Object object2) {
        if (object2 instanceof Boolean) {
            ((Boolean)object2).booleanValue();
            if (object == this.paramCheck) {
                ((JCTextComponent)this.fileSelector.nameField).setText("*.html");
                return;
            }
            if (object == this.serialCheck) {
                ((JCTextComponent)this.fileSelector.nameField).setText("*.ser");
                return;
            }
        } else if (object == this.fileSelector) {
            this.fileSelector.getDirectory();
            String string = this.fileSelector.getFile();
            if (((Boolean)this.serialCheck.getValue()).booleanValue()) {
                this.loadSerialized(string);
                return;
            }
            if (((Boolean)this.paramCheck.getValue()).booleanValue()) {
                this.loadParams(string);
            }
        }
    }

    private void loadSerialized(String string) {
        if (string != null) {
            System.out.println("Try to Read object from: " + string);
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                Object object = objectInputStream.readObject();
                fileInputStream.close();
                this.setObject(object);
                return;
            }
            catch (Exception exception) {
                JCCustomizerPage.showError("Failed to read serialized file:\n" + exception);
                exception.printStackTrace(System.out);
                return;
            }
        }
    }

    private void loadParams(String string) {
        System.out.println("Load Params from: " + string);
        JCChart jCChart = null;
        if (this.getObject() instanceof JCChart) {
            jCChart = (JCChart)this.getObject();
        } else if (this.model instanceof JCChart) {
            jCChart = (JCChart)this.model;
        }
        if (jCChart != null) {
            jCChart.loadParams(string);
            this.setObject(jCChart);
            return;
        }
        JCCustomizerPage.showError("JCLoadDialog: no Chart instance");
    }

    public void launch() {
        Frame frame = JCPropertyPage.getFrame(this);
        if (frame == null) {
            try {
                frame = this.getDialogFrame();
                frame.setTitle(JCLoadDialog.getPageTitle());
                frame.setLayout(new GridLayout(1, 1));
                frame.add(this);
                frame.pack();
                Dimension dimension = this.preferredSize();
                frame.resize(dimension.width + 10, dimension.height + 30);
            }
            catch (Throwable throwable) {
                JCCustomizerPage.showError("JCCustomizerPage launch():\n" + throwable);
                frame = null;
            }
        }
        if (frame != null) {
            frame.show();
        }
    }

    public static void main(String[] stringArray) {
        String string = JCLoadDialog.getPageName();
        JCPropertyPage jCPropertyPage = JCPropertyPage.getPage(string);
        jCPropertyPage.init();
        jCPropertyPage.launch();
        Frame frame = JCPropertyPage.getFrame(jCPropertyPage);
        frame.setTitle(JCLoadDialog.getPageTitle());
        jCPropertyPage.setObject(new TestChart());
    }

    public static String getPageTitle() {
        return "JClass Load Dialog";
    }

    public static String getPageName() {
        return "JCLoadDialog";
    }
}

